import Foundation
import HealthKit

/// Core health data model for LifeClock Watch App
struct HealthData {
    let id = UUID()
    let dateRecorded: Date
    let heartRate: Double?
    let stepCount: Int?
    let bodyMass: Double?
    let height: Double?
    let bloodPressureSystolic: Double?
    let bloodPressureDiastolic: Double?
    
    init(dateRecorded: Date = Date(),
         heartRate: Double? = nil,
         stepCount: Int? = nil,
         bodyMass: Double? = nil,
         height: Double? = nil,
         bloodPressureSystolic: Double? = nil,
         bloodPressureDiastolic: Double? = nil) {
        self.dateRecorded = dateRecorded
        self.heartRate = heartRate
        self.stepCount = stepCount
        self.bodyMass = bodyMass
        self.height = height
        self.bloodPressureSystolic = bloodPressureSystolic
        self.bloodPressureDiastolic = bloodPressureDiastolic
    }
}

/// Life prediction model
struct LifePrediction {
    let id = UUID()
    let dateCreated: Date
    let predictedLifespan: Double
    let remainingYears: Double
    let ageAtPrediction: Double
    let confidenceScore: Double
    
    init(predictedLifespan: Double,
         remainingYears: Double,
         ageAtPrediction: Double,
         confidenceScore: Double,
         dateCreated: Date = Date()) {
        self.predictedLifespan = predictedLifespan
        self.remainingYears = remainingYears
        self.ageAtPrediction = ageAtPrediction
        self.confidenceScore = confidenceScore
        self.dateCreated = dateCreated
    }
}